import re

def fix_indentation(input_file, output_file):
    with open(input_file, 'r') as f:
        lines = f.readlines()
    
    fixed_lines = []
    in_multiline_string = False
    current_indent = 0
    
    for line in lines:
        # Skip empty lines or preserve their indentation
        if line.strip() == '':
            fixed_lines.append(line)
            continue
        
        # Count leading spaces to determine indent level
        stripped_line = line.lstrip()
        indent_spaces = len(line) - len(stripped_line)
        
        # Calculate indentation level (assuming 4 spaces per level)
        indent_level = indent_spaces // 4
        
        # Fix obvious indentation errors
        if indent_level > current_indent + 1:
            # This line is indented too far
            indent_level = current_indent + 1
        
        # Adjust indent level based on line content
        if re.match(r'\s*for\s+', line) or re.match(r'\s*if\s+', line) or re.match(r'\s*elif\s+', line) or re.match(r'\s*else\s*:', line):
            # This is a control flow statement, next line should be indented
            next_indent = indent_level + 1
        elif re.match(r'\s*def\s+', line) or re.match(r'\s*class\s+', line):
            # Function or class definition, next line should be indented
            next_indent = indent_level + 1
        else:
            # Otherwise keep the same indentation
            next_indent = indent_level
        
        # Create properly indented line
        fixed_line = ' ' * (indent_level * 4) + stripped_line
        fixed_lines.append(fixed_line)
        
        current_indent = next_indent
    
    # Write fixed content to output file
    with open(output_file, 'w') as f:
        f.writelines(fixed_lines)

# Fix indentation in battle_scene.py
fix_indentation('game/ui/battle_scene.py', 'game/ui/battle_scene_fixed.py') 