#!/usr/bin/env python3

"""
Simple script to add a new mission with specific Chaos units
"""

import os
import re

def add_chaos_mission():
    """Add a new mission featuring Khorne Berzerkers and Lord of Skulls"""
    mission_scene_path = os.path.join("game", "ui", "mission_scene.py")
    
    if not os.path.exists(mission_scene_path):
        print(f"Error: Mission scene file not found at: {mission_scene_path}")
        return
        
    print(f"Opening mission file: {mission_scene_path}")
    
    try:
        # Read the file content
        with open(mission_scene_path, 'r') as f:
            content = f.read()
            
        # Look for the mission list
        mission_list_match = re.search(r'self\.mission_list\s*=\s*\[(.*?)\]', content, re.DOTALL)
        
        if not mission_list_match:
            print("Error: Could not find mission list in the file.")
            return
            
        # Get the mission list content
        mission_list_text = mission_list_match.group(1)
        
        # Find the end of the last mission
        last_mission_end = mission_list_text.rstrip().rfind("}")
        
        if last_mission_end <= 0:
            print("Error: Could not find the end of the last mission.")
            return
            
        # Create a new Khorne Berzerkers mission
        berzerker_mission = """
            ,{
                "id": "mission_khorne",
                "name": "Blood Crusade: Khorne Berzerkers",
                "description": "Face the fearsome Khorne Berzerkers in their blood-soaked fortress.",
                "difficulty": "Hard",
                "reward": 800,
                "location": "Chaos Fortress",
                "unlocked": True,
                "completed": False,
                "enemy_faction": "chaos_marines",
                "enemy_unit_types": ["chaos_berzerker", "chaos_marine", "chaos_marine"]
            }"""
            
        # Create a new Lord of Skulls mission
        skull_lord_mission = """
            ,{
                "id": "mission_skulls",
                "name": "Blood for the Blood God",
                "description": "Battle the monstrous Khorne Lord of Skulls and its followers.",
                "difficulty": "Super Hard",
                "reward": 1200,
                "location": "Desecrated Imperial Cathedral",
                "unlocked": True,
                "completed": False,
                "enemy_faction": "chaos_marines",
                "enemy_unit_types": ["lord_of_skulls", "chaos_berzerker", "chaos_marine"]
            }"""
        
        # Insert the new missions
        updated_list_text = mission_list_text[:last_mission_end+1] + berzerker_mission + skull_lord_mission + mission_list_text[last_mission_end+1:]
        updated_content = content.replace(mission_list_text, updated_list_text)
        
        # Write the updated content back to the file
        with open(mission_scene_path, 'w') as f:
            f.write(updated_content)
            
        print("Successfully added 2 new missions:")
        print("  - Blood Crusade: Khorne Berzerkers")
        print("  - Blood for the Blood God (featuring Lord of Skulls)")
            
    except Exception as e:
        print(f"Error: {str(e)}")

if __name__ == "__main__":
    add_chaos_mission() 