#!/usr/bin/env python3

import json
import os

def add_berzerker():
    # Path to chaos_marines.json
    chaos_file = os.path.join("game", "data", "units", "chaos_marines.json")
    
    # Check if file exists
    if not os.path.exists(chaos_file):
        print(f"Error: Chaos Marines file not found at {chaos_file}")
        return
    
    # Load the file
    try:
        with open(chaos_file, 'r') as f:
            chaos_data = json.load(f)
    except Exception as e:
        print(f"Error reading file: {e}")
        return
    
    # Check if berzerker already exists
    if "chaos_berzerker" in chaos_data:
        print("Berzerker already exists in the file.")
        return
    
    # Add berzerker definition
    chaos_data["chaos_berzerker"] = {
        "name": "Khorne Berzerker",
        "hp": 140,
        "max_hp": 140,
        "attack": 35,
        "defense": 15,
        "move_range": 4,
        "attack_range": 1,
        "abilities": ["chain_axe", "chainblade", "blood_for_the_blood_god", "berserk_rage"],
        "size": [1, 1],
        "attack_damage_type": "normal",
        "faction": "chaos_marines"
    }
    
    # Save the updated file
    try:
        with open(chaos_file, 'w') as f:
            json.dump(chaos_data, f, indent=2)
        print("Successfully added Khorne Berzerker to Chaos Marines!")
    except Exception as e:
        print(f"Error saving file: {e}")

if __name__ == "__main__":
    add_berzerker() 