"""
Unit Factory Test Module
Tests the unit factory functionality
"""
from game.core.unit_factory import UnitFactory

def test_template_units():
    """Test creating units from templates"""
    # Create a space marine from template
    space_marine = UnitFactory.create_unit_from_template("space_marine_tactical")
    print(f"Created from template: {space_marine}")
    print(f"Abilities: {space_marine.abilities}")
    print(f"Stats: HP={space_marine.stats['hp']}, ATK={space_marine.stats['attack']}, DEF={space_marine.stats['defense']}")
    print("\n")
    
    # Create an ork from template with custom name and level
    ork = UnitFactory.create_unit_from_template("ork_boy", name="Grumlok da Choppa", level=3)
    print(f"Created from template with custom name and level: {ork}")
    print(f"Abilities: {ork.abilities}")
    print(f"Stats: HP={ork.stats['hp']}, ATK={ork.stats['attack']}, DEF={ork.stats['defense']}")
    print("\n")
    
    return True

def test_custom_units():
    """Test creating custom units"""
    # Create a custom Eldar unit
    eldar = UnitFactory.create_custom_unit(
        "Uthwe Warlock",
        "eldar",
        "elite",
        level=2,
        custom_abilities=["Ancient Reflexes", "Psychic Powers", "Rune Armor"]
    )
    print(f"Created custom unit: {eldar}")
    print(f"Abilities: {eldar.abilities}")
    print(f"Stats: HP={eldar.stats['hp']}, ATK={eldar.stats['attack']}, DEF={eldar.stats['defense']}")
    print("\n")
    
    # Create a custom Necron unit
    necron = UnitFactory.create_custom_unit(
        "Royal Warden",
        "necrons",
        "ranged",
        level=2
    )
    print(f"Created custom unit with default abilities: {necron}")
    print(f"Abilities: {necron.abilities}")
    print(f"Stats: HP={necron.stats['hp']}, ATK={necron.stats['attack']}, DEF={necron.stats['defense']}")
    print("\n")
    
    return True

if __name__ == "__main__":
    print("Testing Template Units...")
    test_template_units()
    
    print("Testing Custom Units...")
    test_custom_units() 