"""
Unit Test Module
Tests basic functionality of the Unit class
"""
from game.core.unit import Unit

def test_unit_creation():
    """Test basic unit creation and stats"""
    # Create a Space Marine unit
    marine = Unit("Brother Titus", "space_marines", "tactical", level=1)
    print(f"Created unit: {marine}")
    print(f"HP: {marine.current_hp}/{marine.stats['hp']}")
    print(f"Attack: {marine.stats['attack']}")
    print(f"Defense: {marine.stats['defense']}")
    print(f"Abilities: {marine.abilities}")
    print("\n")
    
    # Create an Ork unit
    ork = Unit("Warboss Grimskull", "orks", "melee", level=3)
    print(f"Created unit: {ork}")
    print(f"HP: {ork.current_hp}/{ork.stats['hp']}")
    print(f"Attack: {ork.stats['attack']}")
    print(f"Defense: {ork.stats['defense']}")
    print(f"Abilities: {ork.abilities}")
    print("\n")
    
    # Create a Tau unit
    tau = Unit("Shas'O Kais", "tau", "ranged", level=2)
    print(f"Created unit: {tau}")
    print(f"HP: {tau.current_hp}/{tau.stats['hp']}")
    print(f"Attack: {tau.stats['attack']}")
    print(f"Defense: {tau.stats['defense']}")
    print(f"Abilities: {tau.abilities}")
    print("\n")
    
    return True

def test_unit_combat():
    """Test basic combat mechanics"""
    marine = Unit("Brother Titus", "space_marines", "tactical", level=1)
    ork = Unit("Ork Boy", "orks", "melee", level=1)
    
    print(f"Combat between {marine.name} and {ork.name}")
    print(f"{marine.name} HP: {marine.current_hp}/{marine.stats['hp']}")
    print(f"{ork.name} HP: {ork.current_hp}/{ork.stats['hp']}")
    
    # Marine attacks ork
    damage = max(5, marine.stats["attack"] - ork.stats["defense"] // 2)
    print(f"{marine.name} attacks for {damage} damage")
    ork.take_damage(damage)
    print(f"{ork.name} HP: {ork.current_hp}/{ork.stats['hp']}")
    
    # Ork attacks marine if still alive
    if not ork.is_defeated():
        damage = max(5, ork.stats["attack"] - marine.stats["defense"] // 2)
        print(f"{ork.name} attacks for {damage} damage")
        marine.take_damage(damage)
        print(f"{marine.name} HP: {marine.current_hp}/{marine.stats['hp']}")
    else:
        print(f"{ork.name} was defeated!")
    
    return True

def test_unit_levelup():
    """Test unit level up mechanics"""
    eldar = Unit("Farseer Taldeer", "eldar", "elite", level=1)
    print(f"Initial level: {eldar.level}")
    print(f"Initial HP: {eldar.stats['hp']}")
    print(f"Initial Attack: {eldar.stats['attack']}")
    
    # Level up the unit
    eldar.level_up()
    
    print(f"After level up:")
    print(f"Level: {eldar.level}")
    print(f"HP: {eldar.stats['hp']}")
    print(f"Attack: {eldar.stats['attack']}")
    
    return True

if __name__ == "__main__":
    print("Testing Unit Creation...")
    test_unit_creation()
    
    print("Testing Combat Mechanics...")
    test_unit_combat()
    
    print("Testing Level Up Mechanics...")
    test_unit_levelup() 