"""
macOS Setup Script for WH40K Tactics
This script creates a standalone macOS application using py2app.

Usage:
    python setup.py py2app
    
Requirements:
    pip install py2app
"""

from setuptools import setup

# Configuration for py2app
APP = ['main.py']
DATA_FILES = [
    ('', ['requirements.txt', 'README.md']),
    ('game', ['game']),
]
OPTIONS = {
    'argv_emulation': True,
    'packages': ['pygame'],
    'iconfile': 'game/assets/images/icon.icns',  # macOS icon file (needs to be created)
    'plist': {
        'CFBundleName': 'WH40K Tactics',
        'CFBundleDisplayName': 'WH40K Tactics',
        'CFBundleVersion': '1.2.0',
        'CFBundleShortVersionString': '1.2.0',
        'NSHumanReadableCopyright': 'Copyright © 2023',
    },
}

setup(
    name="WH40K Tactics",
    app=APP,
    data_files=DATA_FILES,
    options={'py2app': OPTIONS},
    setup_requires=['py2app'],
)

print("""
------------------------------------------------------
macOS build complete!

The app should be in the 'dist' directory.
To distribute the game:
1. Create a DMG from the .app bundle in the dist directory
2. Users can run the game by opening the .app bundle
------------------------------------------------------
""") 