"""
Units Data Module
Contains data definitions for game units
"""

# Faction definitions
FACTIONS = {
    "space_marines": {
        "name": "Space Marines",
        "description": "The Emperor's finest, genetically enhanced super soldiers clad in power armor.",
        "stat_mods": {
            "hp": 20,
            "attack": 5,
            "defense": 5,
            "speed": 0,
            "move_range": 0,
            "attack_range": 0
        },
        "default_ability": "And They Shall Know No Fear",
        "available_types": ["tactical", "assault", "devastator", "scout", "elite"]
    },
    "chaos_marines": {
        "name": "Chaos Marines",
        "description": "Former Space Marines who have turned to the dark powers of Chaos.",
        "stat_mods": {
            "hp": 10,
            "attack": 10,
            "defense": 0,
            "speed": -1,
            "move_range": 0,
            "attack_range": 0
        },
        "default_ability": "Mark of Chaos",
        "available_types": ["tactical", "assault", "devastator", "berzerker", "possessed"]
    },
    "eldar": {
        "name": "Eldar",
        "description": "Ancient and technologically advanced aliens with incredible speed and precision.",
        "stat_mods": {
            "hp": -10,
            "attack": 5,
            "defense": 0,
            "speed": 3,
            "move_range": 1,
            "attack_range": 0
        },
        "default_ability": "Ancient Reflexes",
        "available_types": ["guardian", "aspect_warrior", "warlock", "ranger", "elite"]
    },
    "orks": {
        "name": "Orks",
        "description": "Green-skinned alien brutes who live for battle and conquest.",
        "stat_mods": {
            "hp": 30,
            "attack": 5,
            "defense": -5,
            "speed": 0,
            "move_range": 0,
            "attack_range": 0
        },
        "default_ability": "Waaagh!",
        "available_types": ["boy", "nob", "mekboy", "kommando", "warboss"]
    },
    "tau": {
        "name": "Tau",
        "description": "Highly advanced alien species with superior ranged weaponry.",
        "stat_mods": {
            "hp": -20,
            "attack": 10,
            "defense": 0,
            "speed": 0,
            "move_range": 0,
            "attack_range": 2
        },
        "default_ability": "For the Greater Good",
        "available_types": ["fire_warrior", "pathfinder", "crisis_suit", "stealth_suit", "commander"]
    },
    "necrons": {
        "name": "Necrons",
        "description": "Ancient robotic warriors with self-repair capabilities.",
        "stat_mods": {
            "hp": 10,
            "attack": 0,
            "defense": 10,
            "speed": -2,
            "move_range": 0,
            "attack_range": 0
        },
        "default_ability": "Living Metal",
        "available_types": ["warrior", "immortal", "destroyer", "lychguard", "overlord"]
    }
}

# Unit type definitions
UNIT_TYPES = {
    "melee": {
        "name": "Melee",
        "description": "Specialized in close combat.",
        "stat_mods": {
            "hp": 0,
            "attack": 10,
            "defense": 5,
            "speed": 0,
            "move_range": 0,
            "attack_range": 1  # Fixed range for melee
        },
        "default_ability": "Charge"
    },
    "ranged": {
        "name": "Ranged",
        "description": "Specialized in long-range attacks.",
        "stat_mods": {
            "hp": 0,
            "attack": 5,
            "defense": 0,
            "speed": 0,
            "move_range": 0,
            "attack_range": 3
        },
        "default_ability": "Overwatch"
    },
    "heavy": {
        "name": "Heavy",
        "description": "Heavily armored unit with powerful weapons but reduced mobility.",
        "stat_mods": {
            "hp": 30,
            "attack": 15,
            "defense": 10,
            "speed": -1,
            "move_range": -1,
            "attack_range": 0
        },
        "default_ability": "Suppressive Fire"
    },
    "scout": {
        "name": "Scout",
        "description": "Fast and mobile unit with extended range of movement.",
        "stat_mods": {
            "hp": -20,
            "attack": 0,
            "defense": 0,
            "speed": 2,
            "move_range": 2,
            "attack_range": 0
        },
        "default_ability": "Infiltrate"
    },
    "elite": {
        "name": "Elite",
        "description": "Superior unit with enhanced combat capabilities.",
        "stat_mods": {
            "hp": 20,
            "attack": 10,
            "defense": 10,
            "speed": 1,
            "move_range": 0,
            "attack_range": 0
        },
        "default_ability": "Heroic Intervention"
    }
}

# Specific unit templates (combinations of faction and type with custom stats)
UNIT_TEMPLATES = {
    # Space Marine Units
    "space_marine_tactical": {
        "name": "Space Marine Tactical",
        "faction": "space_marines",
        "unit_type": "ranged",
        "abilities": ["And They Shall Know No Fear", "Bolter Discipline"],
        "base_level": 1
    },
    "space_marine_assault": {
        "name": "Space Marine Assault",
        "faction": "space_marines",
        "unit_type": "melee",
        "abilities": ["And They Shall Know No Fear", "Jump Pack Assault"],
        "base_level": 1
    },
    "space_marine_devastator": {
        "name": "Space Marine Devastator",
        "faction": "space_marines",
        "unit_type": "heavy",
        "abilities": ["And They Shall Know No Fear", "Heavy Weapon Support"],
        "base_level": 2
    },
    "space_marine_scout": {
        "name": "Space Marine Scout",
        "faction": "space_marines",
        "unit_type": "scout",
        "abilities": ["And They Shall Know No Fear", "Concealed Positions"],
        "base_level": 1
    },
    "space_marine_terminator": {
        "name": "Space Marine Terminator",
        "faction": "space_marines",
        "unit_type": "elite",
        "abilities": ["And They Shall Know No Fear", "Teleport Strike"],
        "base_level": 3
    },
    
    # Chaos Marine Units
    "chaos_berzerker": {
        "name": "Chaos Berzerker",
        "faction": "chaos_marines",
        "unit_type": "melee",
        "abilities": ["Mark of Chaos", "Blood for the Blood God"],
        "base_level": 1
    },
    "chaos_marine": {
        "name": "Chaos Marine",
        "faction": "chaos_marines",
        "unit_type": "ranged",
        "abilities": ["Mark of Chaos", "Dark Bolter"],
        "base_level": 1
    },
    "chaos_havoc": {
        "name": "Chaos Havoc",
        "faction": "chaos_marines",
        "unit_type": "heavy",
        "abilities": ["Mark of Chaos", "Chaos Heavy Weapons"],
        "base_level": 2
    },
    "chaos_possessed": {
        "name": "Chaos Possessed",
        "faction": "chaos_marines",
        "unit_type": "elite",
        "abilities": ["Mark of Chaos", "Daemonic Strength"],
        "base_level": 2
    },
    "chaos_terminator": {
        "name": "Chaos Terminator",
        "faction": "chaos_marines",
        "unit_type": "elite",
        "abilities": ["Mark of Chaos", "Dark Teleport"],
        "base_level": 3
    },
    
    # Ork Units
    "ork_boy": {
        "name": "Ork Boy",
        "faction": "orks",
        "unit_type": "melee",
        "abilities": ["Waaagh!", "Mob Rule"],
        "base_level": 1
    },
    "ork_shoota": {
        "name": "Ork Shoota Boy",
        "faction": "orks",
        "unit_type": "ranged",
        "abilities": ["Waaagh!", "More Dakka"],
        "base_level": 1
    },
    "ork_nob": {
        "name": "Ork Nob",
        "faction": "orks",
        "unit_type": "elite",
        "abilities": ["Waaagh!", "Power Klaw"],
        "base_level": 2
    },
    "ork_loota": {
        "name": "Ork Loota",
        "faction": "orks",
        "unit_type": "heavy",
        "abilities": ["Waaagh!", "Deffgun"],
        "base_level": 2
    },
    "ork_warboss": {
        "name": "Ork Warboss",
        "faction": "orks",
        "unit_type": "elite",
        "abilities": ["Waaagh!", "Warboss Leadership"],
        "base_level": 3
    },
    "eldar_guardian": {
        "name": "Eldar Guardian",
        "faction": "eldar",
        "unit_type": "ranged",
        "abilities": ["Ancient Reflexes", "Shuriken Catapult"],
        "base_level": 1
    },
    "eldar_striking_scorpion": {
        "name": "Eldar Striking Scorpion",
        "faction": "eldar",
        "unit_type": "melee",
        "abilities": ["Ancient Reflexes", "Mandiblasters"],
        "base_level": 2
    },
    "eldar_dire_avenger": {
        "name": "Eldar Dire Avenger",
        "faction": "eldar",
        "unit_type": "ranged",
        "abilities": ["Ancient Reflexes", "Bladestorm"],
        "base_level": 2
    },
    "eldar_farseer": {
        "name": "Eldar Farseer",
        "faction": "eldar",
        "unit_type": "elite",
        "abilities": ["Ancient Reflexes", "Psychic Powers", "Guide"],
        "base_level": 3
    },
    "eldar_warlock": {
        "name": "Eldar Warlock",
        "faction": "eldar",
        "unit_type": "elite",
        "abilities": ["Ancient Reflexes", "Psychic Powers", "Destructor"],
        "base_level": 2
    },
    "tau_fire_warrior": {
        "name": "Tau Fire Warrior",
        "faction": "tau",
        "unit_type": "ranged",
        "abilities": ["For the Greater Good", "Pulse Rifle"],
        "base_level": 1
    },
    "necron_warrior": {
        "name": "Necron Warrior",
        "faction": "necrons",
        "unit_type": "ranged",
        "abilities": ["Living Metal", "Gauss Flayer"],
        "base_level": 1
    }
}

# Ability definitions
ABILITIES = {
    # Space Marine Abilities
    "And They Shall Know No Fear": {
        "name": "And They Shall Know No Fear",
        "description": "Space Marines never flee from battle.",
        "effect": "immune_to_fear",
        "cooldown": 0
    },
    "Bolter Discipline": {
        "name": "Bolter Discipline",
        "description": "Fire twice with your bolter.",
        "effect": "double_attack",
        "cooldown": 2
    },
    "Jump Pack Assault": {
        "name": "Jump Pack Assault",
        "description": "Move over obstacles and gain bonus attack.",
        "effect": "jump_attack",
        "cooldown": 3
    },
    "Heavy Weapon Support": {
        "name": "Heavy Weapon Support",
        "description": "Suppress enemy movement and reduce their defense.",
        "effect": "suppression",
        "cooldown": 2
    },
    "Concealed Positions": {
        "name": "Concealed Positions",
        "description": "Gain temporary stealth and increased defense.",
        "effect": "stealth",
        "cooldown": 3
    },
    "Teleport Strike": {
        "name": "Teleport Strike",
        "description": "Teleport to any visible location and attack.",
        "effect": "teleport_attack",
        "cooldown": 4
    },
    
    # Chaos Marine Abilities
    "Mark of Chaos": {
        "name": "Mark of Chaos",
        "description": "Gain strength from the dark gods.",
        "effect": "chaos_empowerment",
        "cooldown": 0
    },
    "Blood for the Blood God": {
        "name": "Blood for the Blood God",
        "description": "Gain bonus attack for each enemy hit.",
        "effect": "blood_frenzy",
        "cooldown": 2
    },
    "Dark Bolter": {
        "name": "Dark Bolter",
        "description": "Corrupt enemy armor with dark energy.",
        "effect": "armor_corruption",
        "cooldown": 2
    },
    "Chaos Heavy Weapons": {
        "name": "Chaos Heavy Weapons",
        "description": "Fire devastating chaos energy.",
        "effect": "chaos_blast",
        "cooldown": 3
    },
    "Daemonic Strength": {
        "name": "Daemonic Strength",
        "description": "Temporarily increase attack and defense.",
        "effect": "daemon_boost",
        "cooldown": 3
    },
    "Dark Teleport": {
        "name": "Dark Teleport",
        "description": "Teleport through the warp and attack.",
        "effect": "warp_teleport",
        "cooldown": 4
    },
    
    # Ork Abilities
    "Waaagh!": {
        "name": "Waaagh!",
        "description": "Orks fight harder when near other Orks.",
        "effect": "mob_rule",
        "cooldown": 0
    },
    "Mob Rule": {
        "name": "Mob Rule",
        "description": "Gain strength from nearby Orks.",
        "effect": "mob_bonus",
        "cooldown": 2
    },
    "More Dakka": {
        "name": "More Dakka",
        "description": "Fire more shots than physically possible.",
        "effect": "extra_shots",
        "cooldown": 2
    },
    "Power Klaw": {
        "name": "Power Klaw",
        "description": "Devastating close combat attack.",
        "effect": "heavy_melee",
        "cooldown": 3
    },
    "Deffgun": {
        "name": "Deffgun",
        "description": "Powerful but unreliable shooting.",
        "effect": "random_damage",
        "cooldown": 2
    },
    "Warboss Leadership": {
        "name": "Warboss Leadership",
        "description": "Inspire nearby Orks to fight harder.",
        "effect": "leadership_aura",
        "cooldown": 3
    },
    
    # Eldar Abilities
    "Ancient Reflexes": {
        "name": "Ancient Reflexes",
        "description": "Eldar move with supernatural speed, improving evasion.",
        "effect": "evasion_boost",
        "cooldown": 0
    },
    "Shuriken Catapult": {
        "name": "Shuriken Catapult",
        "description": "Fire a burst of high-velocity shuriken discs at the enemy.",
        "effect": "rapid_fire",
        "cooldown": 2
    },
    "Mandiblasters": {
        "name": "Mandiblasters",
        "description": "Short-range energy discharge that damages enemies in close combat.",
        "effect": "melee_aoe",
        "cooldown": 3
    },
    "Bladestorm": {
        "name": "Bladestorm",
        "description": "Unleash a rain of shuriken fire that ignores armor.",
        "effect": "armor_piercing",
        "cooldown": 3
    },
    "Psychic Powers": {
        "name": "Psychic Powers",
        "description": "Harness the energies of the warp to damage enemies.",
        "effect": "psychic_attack",
        "cooldown": 0
    },
    "Guide": {
        "name": "Guide",
        "description": "Use psychic powers to guide allies' attacks, improving their accuracy.",
        "effect": "accuracy_boost",
        "cooldown": 3
    },
    "Destructor": {
        "name": "Destructor",
        "description": "Channel destructive energies into a focused beam that melts through armor.",
        "effect": "armor_melt",
        "cooldown": 2
    }
} 