"""
Game State Module
Defines the possible game states
"""
from enum import Enum, auto

class GameState(Enum):
    """
    Enum representing the various states the game can be in
    """
    MAIN_MENU = auto()
    MISSION_SELECT = auto()
    BATTLE = auto()
    CUSTOMIZATION = auto()
    SETTINGS = auto()
    CREDITS = auto()
    TUTORIAL = auto()
    HELP = auto()
    PAUSE = auto()
    GAME_OVER = auto()
    TERMS = auto()  # Terms and conditions screen 