# Image Requirements for Warhammer 40K: Heroes of the Imperium

This document outlines the requirements for images that will be used in the game.

## General Requirements

- **Format**: PNG with transparency (preferred) or JPG
- **Dimensions**: 
  - Unit sprites: 128x128 pixels (1:1 aspect ratio)
  - UI elements: varies by element
  - Backgrounds: 1280x720 pixels (16:9 aspect ratio)
- **Style**: Consistent with Warhammer 40K art style, top-down or 3/4 view for units

## Directory Structure

- `/units/[faction_name]/` - Unit images organized by faction
- `/ui/` - UI elements (buttons, panels, icons)
- `/backgrounds/` - Background images for different scenes

## Required Images by Faction

### Space Marines
- `captain.png` - Space Marine Captain (with power sword and bolt pistol)
- `tactical.png` - Tactical Marine (with bolter)
- `assault.png` - Assault Marine (with jump pack and chainsword)
- `devastator.png` - Devastator Marine (with heavy weapon)
- `terminator.png` - Terminator (in Tactical Dreadnought Armor)
- `librarian.png` - Librarian (psychic user)
- `chaplain.png` - Chaplain (with skull helmet)
- `dreadnought.png` - Dreadnought (walking tank)
- `scout.png` - Scout (lighter armor)
- `primaris.png` - Primaris Marine (newer, larger marine)

### Chaos Marines
- `champion.png` - Chaos Space Marine Champion
- `chaos_marine.png` - Standard Chaos Space Marine
- `berzerker.png` - Khorne Berzerker (melee specialist)
- `plague_marine.png` - Plague Marine (Nurgle)
- `noise_marine.png` - Noise Marine (Slaanesh)
- `thousand_son.png` - Thousand Sons Marine (Tzeentch)
- `chaos_terminator.png` - Chaos Terminator
- `sorcerer.png` - Chaos Sorcerer
- `daemon_prince.png` - Daemon Prince
- `cultist.png` - Chaos Cultist

### Eldar
- `farseer.png` - Eldar Farseer (leader/psychic)
- `guardian.png` - Eldar Guardian (basic troops)
- `dire_avenger.png` - Eldar Dire Avenger (aspect warrior)
- `fire_dragon.png` - Eldar Fire Dragon (aspect warrior)
- `howling_banshee.png` - Eldar Howling Banshee (aspect warrior)
- `ranger.png` - Eldar Ranger (sniper)
- `warlock.png` - Eldar Warlock (psychic)
- `wave_serpent.png` - Eldar Wave Serpent (vehicle)
- `wraithlord.png` - Eldar Wraithlord (construct)
- `autarch.png` - Eldar Autarch (military leader)

### Orks
- `warboss.png` - Ork Warboss (leader)
- `boy.png` - Ork Boy (basic troops)
- `nob.png` - Ork Nob (elite troops)
- `mekboy.png` - Ork Mekboy (technician)
- `weirdboy.png` - Ork Weirdboy (psychic)
- `flash_git.png` - Ork Flash Git (heavy weapons)
- `kommando.png` - Ork Kommando (stealth troops)
- `deffkopta.png` - Ork Deffkopta (flying unit)
- `trukk.png` - Ork Trukk (vehicle)
- `loota.png` - Ork Loota (ranged specialist)

### Tau
- `commander.png` - Tau Commander (leader in battlesuit)
- `fire_warrior.png` - Fire Warrior (basic troops)
- `pathfinder.png` - Pathfinder (scout)
- `crisis_suit.png` - Crisis Battlesuit (elite troops)
- `stealth_suit.png` - Stealth Suit (infiltration)
- `ethereal.png` - Ethereal (caste leader)
- `broadside.png` - Broadside Battlesuit (heavy weapons platform)
- `kroot.png` - Kroot Carnivore (alien auxiliary)
- `vespid.png` - Vespid Stingwing (alien auxiliary)
- `hammerhead.png` - Hammerhead Gunship (vehicle)

### Necrons
- `overlord.png` - Necron Overlord (leader)
- `warrior.png` - Necron Warrior (basic troops)
- `immortal.png` - Necron Immortal (elite troops)
- `destroyer.png` - Necron Destroyer (fast attack)
- `lychguard.png` - Necron Lychguard (bodyguard)
- `cryptek.png` - Necron Cryptek (technician)
- `deathmark.png` - Necron Deathmark (sniper)
- `scarab.png` - Canoptek Scarab (swarm)
- `wraith.png` - Canoptek Wraith (phase unit)
- `monolith.png` - Necron Monolith (heavy vehicle)

## UI Elements

- `button_normal.png` - Standard button
- `button_hover.png` - Button hover state
- `button_pressed.png` - Button pressed state
- `panel_background.png` - Panel background
- `title_logo.png` - Game title logo
- `faction_icons/[faction_name].png` - Icon for each faction
- `weapon_icons/[weapon_type].png` - Icons for different weapon types
- `armor_icons/[armor_type].png` - Icons for different armor types

## Backgrounds

- `main_menu.png` - Main menu background
- `mission_select.png` - Mission selection screen background
- `battle_[terrain_type].png` - Battle backgrounds for different terrain types (e.g., battle_urban.png, battle_desert.png)
- `customization.png` - Customization screen background 