# How to Add Images to the Game

This file explains how to add images to the Warhammer 40K: Heroes of the Imperium game.

## Image Directory Structure

The game uses the following directory structure for images:

```
game/assets/images/
├── units/
│   ├── space_marines/
│   ├── chaos_marines/
│   ├── eldar/
│   ├── orks/
│   ├── tau/
│   └── necrons/
├── ui/
└── backgrounds/
```

## Unit Images

Unit images should be placed in the appropriate faction directory under `units/`. The recommended format is PNG with transparency.

### Naming Convention

Unit images should be named according to their type or role:

- `captain.png` - Space Marine Captain
- `tactical.png` - Tactical Marine
- `assault.png` - Assault Marine
- etc.

For example, a Space Marine Captain image would be placed at:
`game/assets/images/units/space_marines/captain.png`

### Image Requirements

- **Format**: PNG with transparency
- **Size**: 128x128 pixels (recommended)
- **Style**: Top-down or 3/4 view for consistency

## UI Elements

UI elements such as buttons, panels, and icons should be placed in the `ui/` directory.

## Backgrounds

Background images for different scenes should be placed in the `backgrounds/` directory.

## Adding New Units

When adding a new unit type:

1. Place the image in the appropriate faction directory
2. If it's a completely new unit type, you may need to update `game/data/units_data.py` to include it

## Image Not Found Behavior

If the game cannot find an appropriate image for a unit, it will display a colored placeholder based on the faction:

- Space Marines: Blue
- Chaos Marines: Dark Red
- Eldar: Teal
- Orks: Dark Green
- Tau: Orange
- Necrons: Green

## Testing Your Images

After adding images, run the game to see them in action. The game will automatically detect and load images from the appropriate directories.

If you encounter any issues with your images not displaying correctly, check:

1. The file is in the correct location
2. The file is named correctly
3. The file is in PNG format with transparency
4. The file size is appropriate (128x128 pixels recommended) 