import random

def run_default_ai(battle_scene, units):
    """Default AI behavior for factions without specific implementation"""
    for enemy_unit in units:
        # Find nearest player unit
        nearest_player_unit = None
        nearest_distance = float('inf')
        
        for player_unit in battle_scene.player_units:
            distance = battle_scene._calculate_distance(enemy_unit['position'], player_unit['position'])
            if distance < nearest_distance:
                nearest_distance = distance
                nearest_player_unit = player_unit
        
        if nearest_player_unit:
            # If in attack range, attack
            if nearest_distance <= enemy_unit['attack_range']:
                # Calculate and apply damage
                damage = max(5, enemy_unit['attack'] - nearest_player_unit['defense'] // 2) + random.randint(-3, 3)
                nearest_player_unit['hp'] = max(0, nearest_player_unit['hp'] - damage)
                
                battle_scene.battle_message = f"Enemy {enemy_unit['name']} attacks {nearest_player_unit['name']} for {damage} damage!"
                
                # Check if the player unit was defeated
                if nearest_player_unit['hp'] <= 0:
                    battle_scene._handle_player_unit_defeat(enemy_unit, nearest_player_unit)
            else:
                # Move closer to target
                current_x, current_y = enemy_unit['position']
                target_x, target_y = nearest_player_unit['position']
                
                # Determine direction to move
                dx = 1 if target_x > current_x else -1 if target_x < current_x else 0
                dy = 1 if target_y > current_y else -1 if target_y < current_y else 0
                
                # Try to move
                if battle_scene._try_move_enemy_unit(enemy_unit, current_x + dx, current_y + dy) or \
                   battle_scene._try_move_enemy_unit(enemy_unit, current_x + dx, current_y) or \
                   battle_scene._try_move_enemy_unit(enemy_unit, current_x, current_y + dy):
                    battle_scene.battle_message = f"Enemy {enemy_unit['name']} moves toward {nearest_player_unit['name']}." 