# Warhammer 40K: Heroes of the Imperium - Development Guide

This guide provides information on how to extend and enhance the game for future development.

## Project Structure

The game is structured in a modular way to facilitate easy extension:

- `game/core/`: Core game systems and classes
- `game/ui/`: User interface and scenes
- `game/data/`: Game data and configurations
- `game/assets/`: Game assets (images, sounds)

## Adding New Content

### Adding New Units

To add new units to the game:

1. Define new unit templates in `game/data/units_data.py` under the `UNIT_TEMPLATES` dictionary.
2. Create instances of these units using the `UnitFactory` class.

Example of adding a new unit template:

```python
# In game/data/units_data.py
UNIT_TEMPLATES["space_marine_terminator"] = {
    "name": "Space Marine Terminator",
    "faction": "space_marines",
    "unit_type": "heavy",
    "abilities": ["And They Shall Know No Fear", "Teleport Strike", "Storm Bolter"],
    "base_level": 3
}
```

### Adding New Factions

To add a new faction:

1. Add the faction definition to `game/data/units_data.py` under the `FACTIONS` dictionary.
2. Create unit templates for this faction.

Example:

```python
# In game/data/units_data.py
FACTIONS["tyranids"] = {
    "name": "Tyranids",
    "description": "Alien hive mind creatures that consume all biomass in their path.",
    "stat_mods": {
        "hp": 15,
        "attack": 8,
        "defense": -2,
        "speed": 1,
        "move_range": 0,
        "attack_range": 0
    },
    "default_ability": "Synapse Creature",
    "available_types": ["gaunt", "warrior", "carnifex", "lictor", "hive_tyrant"]
}
```

### Adding New Abilities

Abilities are defined in the unit templates and applied during combat.

To implement new abilities:

1. Add ability logic to the battle system in `game/ui/battle_scene.py`.
2. Update unit templates to include the new abilities.

## Extending Game Mechanics

### Combat System

The turn-based combat system is defined in `game/ui/battle_scene.py`. You can extend it by:

- Adding new action types beyond move and attack
- Implementing terrain effects
- Adding status effects to units
- Implementing special abilities that change the battle flow

### Progression System

Enhance the progression system by:

- Adding experience points to units after battles
- Implementing equipment systems with stat bonuses
- Adding skill trees for units to unlock new abilities

## Graphics and UI

To enhance the visual aspects:

1. Add sprite images to `game/assets/images/`
2. Update `ResourceManager` to load and manage these sprites
3. Replace the current shape rendering with sprite rendering in the scene classes

## Future Development Steps

Based on the project specification, the next steps would be:

1. **Stage 2: Unit System Development**
   - Implement distinct units with moves, stats, and evolution paths
   - Enhance combat system (attacks, special abilities, items)

2. **Stage 3: Mission Structure**
   - Develop story and side missions with progression system
   - Implement reward system (items, unit unlocks)

3. **Stage 4: Customization & Progression**
   - Expand Space Marine protagonist customization
   - Implement unit leveling, equipment upgrades, and skill unlock system

## Testing

When adding new features, create test files similar to `test_unit.py` and `test_unit_factory.py` to verify functionality.

## Contributing

When contributing to the project:

1. Ensure your code follows the existing structure and style
2. Document new classes and functions with docstrings
3. Test new functionality thoroughly
4. Update this guide with information about new systems or extensions 