# PowerShell Launcher for WH40K Tactics Game
# A more sophisticated launcher with better error handling

# Set window title
$host.UI.RawUI.WindowTitle = "WH40K Tactics Launcher"

# Color settings
$normalColor = "White"
$errorColor = "Red"
$successColor = "Green"
$highlightColor = "Yellow"

function Show-Header {
    Write-Host ""
    Write-Host "===============================================" -ForegroundColor $highlightColor
    Write-Host "         WARHAMMER 40K TACTICS LAUNCHER        " -ForegroundColor $highlightColor
    Write-Host "===============================================" -ForegroundColor $highlightColor
    Write-Host ""
}

function Check-PythonInstalled {
    try {
        $pythonVersion = python --version 2>&1
        if ($pythonVersion -match "Python 3") {
            Write-Host "✓ Python detected: " -ForegroundColor $successColor -NoNewline
            Write-Host "$pythonVersion" -ForegroundColor $normalColor
            return $true
        } else {
            Write-Host "✗ Python 3 not detected. Found: $pythonVersion" -ForegroundColor $errorColor
            return $false
        }
    } catch {
        Write-Host "✗ Python is not installed or not in your PATH." -ForegroundColor $errorColor
        return $false
    }
}

function Launch-Game {
    # Navigate to script directory 
    $scriptPath = Split-Path -Parent $MyInvocation.MyCommand.Path
    Set-Location -Path $scriptPath
    
    Write-Host ""
    Write-Host "Launching game... " -ForegroundColor $highlightColor
    Write-Host ""
    
    try {
        python main.py
        if ($LASTEXITCODE -eq 0) {
            Write-Host ""
            Write-Host "Game closed successfully." -ForegroundColor $successColor
        } else {
            Write-Host ""
            Write-Host "Game exited with error code: $LASTEXITCODE" -ForegroundColor $errorColor
        }
    } catch {
        Write-Host "Failed to launch game: $_" -ForegroundColor $errorColor
    }
}

# Main execution
Show-Header

if (Check-PythonInstalled) {
    Launch-Game
} else {
    Write-Host ""
    Write-Host "Please install Python 3.7 or higher from python.org" -ForegroundColor $errorColor
    Write-Host "After installing Python, make sure to check 'Add Python to PATH'" -ForegroundColor $errorColor
}

Write-Host ""
Write-Host "Press any key to exit..." -ForegroundColor $normalColor
$null = $host.UI.RawUI.ReadKey("NoEcho,IncludeKeyDown") 